// ZEN Study Plus バージョン通知機能
// ウェブサイト側でバージョン確認を行うためのスクリプト

(function() {
    // 拡張機能がインストールされていることを示すためのマーカーを追加
    const marker = document.createElement('div');
    marker.id = 'zen-study-plus-extension-marker';
    marker.style.display = 'none';
    marker.setAttribute('data-extension-version', chrome.runtime.getManifest().version);
    document.body.appendChild(marker);

    // ウェブサイト側からのバージョン確認リクエストをリッスン
    window.addEventListener('message', function(event) {
        // セキュリティ: 同一オリジンからのメッセージのみ処理
        if (event.origin !== window.location.origin) return;
        
        if (event.data.type === 'GET_EXTENSION_VERSION') {
            // 拡張機能のバージョン情報をウェブサイトに返送
            const response = {
                type: 'EXTENSION_VERSION_RESPONSE',
                version: chrome.runtime.getManifest().version,
                isInstalled: true
            };
            
            window.postMessage(response, window.location.origin);
        }
    });
})();
